 ; Ŀ
 ;   Wolf - colinear line consolidator.                                    
 ;   Copyright 1994, 2010 by Rocket Software Ltd.                          
 ;   Originally named Pride, which is what you get when you put a number   
 ;   of lions together.  Wolf has fewer letters, though.                   
 ; 

 ; Ŀ
 ;   Loup - replacement error handler.                                     
 ; 
 (DEFUN LOUP (shk)
  (setq *error* prev)
  (command "undo" "b")
 (princ))
 ; Ŀ
 ;   Loup end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Peach: see if two lines are parallel, perpendicular        
 ;   colinear, or convergent.                                              
 ; 
 (DEFUN PEACH (lin1 lin2 / dimscl l1 l2 ang1 ang2 lin210 lin211 hyp1p1 hyp1p2
                                 hyp2p1 hyp2p2 inter1 inter2 dist1 dist2 join)
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
 ; Ŀ
 ;   Get the scale, depending on which space we are in and other things.   
 ; 
  (if misps
      (setq dimscl (misps))
      (setq dimscl (getvar "dimscale")))
 ; Ŀ
 ;   Extract entity data from the two lines.                               
 ; 
  (setq l1 (entget lin1))
  (setq l2 (entget lin2))
 ; Ŀ
 ;   Find their angles.                                                    
 ; 
  (setq ang1 (angle (cdr (assoc 10 l1)) (cdr (assoc 11 l1))))
  (setq ang2 (angle (setq lin210 (cdr (assoc 10 l2)))
                    (setq lin211 (cdr (assoc 11 l2)))))
 ; Ŀ
 ;   Make two theoretical lines perpendicular to line 1, each starting at  
 ;   one of its endpoints and with a nominal length of 10 units.           
 ; 
  (setq hyp1p1 (cdr (assoc 10 l1)))
  (setq hyp1p2 (polar hyp1p1 (+ ang1 (/ pi 2)) 10))
  (setq hyp2p1 (cdr (assoc 11 l1)))
  (setq hyp2p2 (polar hyp2p1 (+ ang1 (/ pi 2)) 10))
 ; Ŀ
 ;   Now find the intersection of each hypothetical line with line2.       
 ; 
  (setq inter1 (inters lin210 lin211 hyp1p1 hyp1p2 ()))
  (setq inter2 (inters lin210 lin211 hyp2p1 hyp2p2 ()))
 ; Ŀ
 ;   And thus find the distances between lines 1 and 2 at the ends of      
 ;   line 1.                                                               
 ; 
  (if inter1 (setq dist1 (distance hyp1p1 inter1)))
  (if inter2 (setq dist2 (distance hyp2p1 inter2)))
  (cond ((and (= dist1 0) (= dist2 0))                       ; colinear
         (setq join T))
        ((and (equal dist1 0 dimscl) (equal dist2 0 dimscl)) ; fairly colinear
         (setq join T))
        ((or (null inter1) (null inter2))                    ; perpendicular
         (setq join ()))
        ((equal dist1 dist2 (* dimscl 0.000001))             ; parallel
         (setq join ()))
        (T                                                   ; converge
         (setq join ())))
  join)
 ; Ŀ
 ;   Peach end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Canis - find the most widely separated endpoints on two    
 ;   lines, stretch one between the two and erase the other.               
 ; 
 (DEFUN CANIS (lin1 l2 / lin2 ten1 ten2 elv1 elv2 dist1 dist2 dist3 pa dist4
                                                                          pb)
  (setq lin1 (entget lin1))
  (setq lin2 (entget l2))              ; save the ename to entdel later
  (setq ten1 (cdr (assoc 10 lin1)))
  (setq ten2 (cdr (assoc 10 lin2)))
  (setq elv1 (cdr (assoc 11 lin1)))
  (setq elv2 (cdr (assoc 11 lin2)))
  (setq dist1 (distance ten1 ten2))
  (setq dist2 (distance ten1 elv1))
  (setq dist3 (distance ten1 elv2))
  (cond ((and (>= dist1 dist2) (>= dist1 dist3))
         (setq pa ten2))
        ((and (>= dist2 dist1) (>= dist2 dist3))
         (setq pa elv1))
        ((and (>= dist3 dist1) (>= dist3 dist2))
         (setq pa elv2))
        (T
         (setq pa ten1)))
  (setq dist1 (distance pa ten1))
  (setq dist2 (distance pa ten2))
  (setq dist3 (distance pa elv1))
  (setq dist4 (distance pa elv2))
  (cond ((and (>= dist1 dist2) (>= dist1 dist3) (>= dist1 dist4))
         (setq pb ten1))
        ((and (>= dist2 dist1) (>= dist2 dist3) (>= dist2 dist4))
         (setq pb ten2))
        ((and (>= dist3 dist1) (>= dist3 dist2) (>= dist3 dist4))
         (setq pb elv1))
        ((and (>= dist4 dist1) (>= dist4 dist2) (>= dist4 dist3))
         (setq pb elv2))
        (T
         (setq pb ten2)))
  (entdel l2)                                           ; erase line 2
  (setq lin1 (subst (cons 10 pa) (assoc 10 lin1) lin1)) ; change start
  (entmod (subst (cons 11 pb) (assoc 11 lin1) lin1))    ; and end
 (princ))
 ; Ŀ
 ;   Canis end.                                                            
 ; 

 ; Ŀ
 ;   Wolf.                                                                 
 ;                                                                         
 ; 
 (DEFUN C:WOLF (/ prev *error* ss num nn lin1 lin2)
  (setvar "cmdecho" 0)
  (command "undo" "mark")
  (setq prev *error*)
  (setq *error* loup)                            ; redefine the error handler
  (prompt "Select lines:")
  (setq ss (ssget))
 ; Ŀ
 ;   Remove everything but lines from the ss.                              
 ; 
  (setq num 0)
  (while (and ss (setq nn (ssname ss num)))
         (if (= (cdr (assoc 0 (entget nn))) "LINE")
             (setq num (1+ num))
             (ssdel nn ss)))
 ; Ŀ
 ;   And process the remainder.                                            
 ; 
  (while (and ss (> (sslength ss) 1))        ; while ss contains > 1 line
         (setq lin1 (ssname ss 0))
         (setq num 1)
         (while (setq lin2 (ssname ss num))
                (if (peach lin1 lin2)
                    (progn
                         (canis lin1 lin2)
                         (ssdel lin2 ss))
                    (setq num (1+ num))))
         (ssdel lin1 ss))
  (setq *error* loup)
 (princ))